/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.MultiSegmentReader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StaleReaderException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;

abstract class DirectoryIndexReader
extends IndexReader {
    protected Directory directory;
    protected boolean closeDirectory;
    private IndexDeletionPolicy deletionPolicy;
    private SegmentInfos segmentInfos;
    private Lock writeLock;
    private boolean stale;
    private boolean rollbackHasChanges;
    private SegmentInfos rollbackSegmentInfos;

    void init(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory) {
        this.directory = directory;
        this.segmentInfos = segmentInfos;
        this.closeDirectory = closeDirectory;
    }

    protected DirectoryIndexReader() {
    }

    DirectoryIndexReader(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory) {
        this.init(directory, segmentInfos, closeDirectory);
    }

    static DirectoryIndexReader open(Directory directory, final boolean closeDirectory, final IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, IOException {
        return (DirectoryIndexReader)new SegmentInfos.FindSegmentsFile(directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.directory, segmentFileName);
                DirectoryIndexReader reader = infos.size() == 1 ? SegmentReader.get(infos, infos.info(0), closeDirectory) : new MultiSegmentReader(this.directory, infos, closeDirectory);
                reader.setDeletionPolicy(deletionPolicy);
                return reader;
            }
        }.run();
    }

    public final synchronized IndexReader reopen() throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (this.hasChanges || this.isCurrent()) {
            return this;
        }
        return (DirectoryIndexReader)new SegmentInfos.FindSegmentsFile(this.directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.directory, segmentFileName);
                DirectoryIndexReader newReader = DirectoryIndexReader.this.doReopen(infos);
                if (DirectoryIndexReader.this != newReader) {
                    newReader.init(this.directory, infos, DirectoryIndexReader.this.closeDirectory);
                    newReader.deletionPolicy = DirectoryIndexReader.this.deletionPolicy;
                }
                return newReader;
            }
        }.run();
    }

    protected abstract DirectoryIndexReader doReopen(SegmentInfos var1) throws CorruptIndexException, IOException;

    public void setDeletionPolicy(IndexDeletionPolicy deletionPolicy) {
        this.deletionPolicy = deletionPolicy;
    }

    public Directory directory() {
        this.ensureOpen();
        return this.directory;
    }

    public long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        return SegmentInfos.readCurrentVersion(this.directory) == this.segmentInfos.getVersion();
    }

    public boolean isOptimized() {
        this.ensureOpen();
        return this.segmentInfos.size() == 1 && !this.hasDeletions();
    }

    protected void doClose() throws IOException {
        if (this.closeDirectory) {
            this.directory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit() throws IOException {
        if (this.hasChanges) {
            if (this.segmentInfos != null) {
                IndexFileDeleter deleter;
                block7: {
                    deleter = new IndexFileDeleter(this.directory, this.deletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : this.deletionPolicy, this.segmentInfos, null, null);
                    this.startCommit();
                    boolean success = false;
                    try {
                        this.commitChanges();
                        this.segmentInfos.write(this.directory);
                        success = true;
                        Object var4_3 = null;
                        if (success) break block7;
                        this.rollbackCommit();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (!success) {
                            this.rollbackCommit();
                            deleter.refresh();
                        }
                        throw throwable;
                    }
                    deleter.refresh();
                    {
                    }
                }
                deleter.checkpoint(this.segmentInfos, true);
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                }
            } else {
                this.commitChanges();
            }
        }
        this.hasChanges = false;
    }

    protected abstract void commitChanges() throws IOException;

    protected void acquireWriteLock() throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        if (this.segmentInfos != null) {
            this.ensureOpen();
            if (this.stale) {
                throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
            }
            if (this.writeLock == null) {
                Lock writeLock = this.directory.makeLock("write.lock");
                if (!writeLock.obtain(IndexWriter.WRITE_LOCK_TIMEOUT)) {
                    throw new LockObtainFailedException("Index locked for write: " + writeLock);
                }
                this.writeLock = writeLock;
                if (SegmentInfos.readCurrentVersion(this.directory) > this.segmentInfos.getVersion()) {
                    this.stale = true;
                    this.writeLock.release();
                    this.writeLock = null;
                    throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
                }
            }
        }
    }

    void startCommit() {
        if (this.segmentInfos != null) {
            this.rollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
        }
        this.rollbackHasChanges = this.hasChanges;
    }

    void rollbackCommit() {
        if (this.segmentInfos != null) {
            for (int i = 0; i < this.segmentInfos.size(); ++i) {
                this.segmentInfos.info(i).reset(this.rollbackSegmentInfos.info(i));
            }
            this.rollbackSegmentInfos = null;
        }
        this.hasChanges = this.rollbackHasChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

